#version 330
#extension GL_EXT_gpu_shader4 : enable
//Galaxies FOREVERMod01.fsh  by  voz
//https://www.shadertoy.com/view/4lyGzK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



//-----------------CONSTANTS MACROS-----------------

#define PI 3.14159265359
#define E 2.7182818284
#define GR 1.61803398875
#define MAX_DIM (max(iResolution.x,iResolution.y))

//-----------------UTILITY MACROS-----------------

#define time ((sin(float(__LINE__))/PI/GR/E+1.0/GR/PI/E)*iTime+1000.0)
#define sphereN(uv) (clamp(1.0-length(uv*2.0-1.0), 0.0, 1.0))
#define clip(x) (smoothstep(0.25, .75, x))
#define TIMES_DETAILED (1.0)
#define angle(uv) (atan(uv.y, uv.x))
#define angle_percent(uv) ((angle(uv)/PI+1.0)/2.0)
#define hash(p) (fract(sin(vec2( dot(p,vec2(127.5,313.7)),dot(p,vec2(239.5,185.3))))*43458.3453))

#define flux(x) (vec3(cos(x),cos(4.0*PI/3.0+x),cos(2.0*PI/3.0+x))*.5+.5)
#define rormal(x) (normalize(sin(vec3(time, time/GR, time*GR)+seedling)*.25+.5))
#define rotatePoint(p,n,theta) (p*cos(theta)+cross(n,p)*sin(theta)+n*dot(p,n) *(1.0-cos(theta)))

float saw(float x)
{
    x/= PI;
    float f = mod(floor(abs(x)), 2.0);
    float m = mod(abs(x), 1.0);
    return f*(1.0-m)+(1.0-f)*m;
}
vec2 saw(vec2 x)
{
    return vec2(saw(x.x), saw(x.y));
}

vec3 saw(vec3 x)
{
    return vec3(saw(x.x), saw(x.y), saw(x.z));
}
vec4 saw(vec4 x)
{
    return vec4(saw(x.x), saw(x.y), saw(x.z), saw(x.w));
}

//-----------------SEEDLINGS-----------------------
float seedling = 0.0;
float stretch = 1.0;
vec2 offset = vec2(0.0);
float last_height = 0.0;
float scale = 1.0;
float extraTurns = 0.0;
float aspect = 1.0;
//-----------------TREES---------------------------
float distTree = 0.0;
float angleTree = 0.0;

//-----------------BASE IMAGE--------------------------

vec4 galaxy(vec2 uv)
{
    vec2 uv0 = uv;
    float r = length(uv);
	uv *= 5.0*(GR);
    
    
    float r1 = log(length(uv)+1.)*2.0;
    float r2 = pow(log(length(uv)+1.)*3.0, .5);
    
    float rotation = iTime*PI*2.0;
    
    float theta1 = atan(uv.y, uv.x)-r1*PI+rotation*.5+seedling;
    float theta2 = atan(uv.y, uv.x)-r2*PI+rotation*.5+seedling;
    
    vec4 color = vec4(flux((seedling*GR+1.0/GR)*time*PI*4.0), 1.0);
    
    vec4 final = (acos(1.0-(cos(theta1)*cos(theta1)+sqrt(cos(theta1+PI)*cos(theta1+PI)))/2.0)*(1.0-log(r1+1.))
              + cos(1.0-(cos(theta2)*cos(theta2)+cos(theta2+PI/2.)*cos(theta2+PI/2.))/2.0)*(1.25-log(r2+1.)))*color;
         
    final.rgba += color;
    
    final /= r1;
    
	final = (clamp(final, 0.0, 1.0));
    
    float weight = clamp(length(clamp(final.rgb, 0.0, 1.0)), 0.0, 1.0);
    return final*smoothstep(0.0, 1.0/GR/PI/E, 1.0-r);
}

//-----------------IMAGINARY TRANSFORMATIONS-----------------

vec2 cmul(vec2 v1, vec2 v2) {
	return vec2(v1.x * v2.x - v1.y * v2.y, v1.y * v2.x + v1.x * v2.y);
}

vec2 cdiv(vec2 v1, vec2 v2) {
	return vec2(v1.x * v2.x + v1.y * v2.y, v1.y * v2.x - v1.x * v2.y) / dot(v2, v2);
}

vec2 mobius(vec2 uv, vec2 multa, vec2 offa, vec2 multb, vec2 offb)
{
    
    //numerator /= (abs(denominator)+1.0);
    
    vec2 quotient = vec2(0.0);
    const int bends = 2;
    for(int i = 0; i < bends; i++)
    {
       	float iteration = float(i)/float(bends);
        vec2 numerator = cmul(uv, multa+sin(vec2(time+seedling-2.0*PI*sin(-iteration+time/GR), time/GR+seedling-2.0*PI*sin(iteration+time)))) + offa
            +sin(vec2(time+seedling-2.0*PI*sin(-iteration+time/GR), time/GR+seedling-2.0*PI*sin(iteration+time)));
        vec2 denominator = cmul(uv, multb+sin(vec2(time+seedling-2.0*PI*sin(-iteration+time/GR), time/GR+seedling-2.0*PI*sin(iteration+time)))) + offb
            +sin(vec2(time+seedling-2.0*PI*sin(-iteration+time/GR), time/GR+seedling-2.0*PI*sin(iteration+time)));
        quotient += (cdiv(numerator, denominator));
        
        
    }
        
    float a = atan(quotient.y, quotient.x);
    
    angleTree = a/PI;
    distTree = length(quotient.xy);
    
    //quotient = rotatePoint(vec3(quotient, 0.0), vec3(0.0, 0.0, 1.0), a).xy;
    vec2 next = quotient;


    float denom = length(fwidth(uv));//max(fwidth(uv.x),fwidth(uv.y));
    denom += 1.0-abs(sign(denom));

    float numer = length(fwidth(next));//min(fwidth(next.x),fwidth(next.y));
    numer += 1.0-abs(sign(numer));

    
    
    stretch = denom/numer;
    
    return quotient;
}

//-----------------ITERATED FUNCTION SYSTEM-----------------

vec2 iterate(vec2 uv, vec2 dxdy, out float magnification, vec2 multa, vec2 offa, vec2 multb, vec2 offb)
{
    uv += offset;
    
    vec2 a = uv+vec2(0.0, 		0.0);
    vec2 b = uv+vec2(dxdy.x, 	0.0);
    vec2 c = uv+vec2(dxdy.x, 	dxdy.y);
    vec2 d = uv+vec2(0.0, 		dxdy.y);//((fragCoord.xy + vec2(0.0, 1.0)) / iResolution.xy * 2.0 - 1.0) * aspect;

    vec2 ma = mobius(a, multa, offa, multb, offb);
    vec2 mb = mobius(b, multa, offa, multb, offb);
    vec2 mc = mobius(c, multa, offa, multb, offb);
    vec2 md = mobius(d, multa, offa, multb, offb);
    
    float da = length(mb-ma);
    float db = length(mc-mb);
    float dc = length(md-mc);
    float dd = length(ma-md);
    
    magnification = stretch;
    
    vec2 final = mobius(uv, multa, offa, multb, offb);
    
    seedling = (floor(final.x)+floor(final.y));
    
    return final;
}
    
vec3 weights[32];

vec4 stars(vec2 uv)
{
    float density = 2.0;
    uv *= density;
    float s = floor(uv.x)*1234.1234+floor(uv.y)*123.123;
    vec2 p = floor(uv)+saw(floor(uv)+iTime+s)*.5+.25;
    
    float l = length(p-uv);
    float f = smoothstep(.1*GR, 1.0, exp(-l*8.0));
    
    return vec4(clamp(flux(time+f+s)*f+f*f*f, 0.0, 1.0), f);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    float scale = E;
    uv = uv*scale-scale/2.0;
    
    float aspect = iResolution.x/iResolution.y;
    
    uv.x *= aspect;
    
    vec2 uv0 = uv;
    
	const int max_iterations = 8;
    int target = max_iterations;//-int(saw(spounge)*float(max_iterations)/2.0);
    vec2 multa, multb, offa, offb;
    
    float antispeckle = 1.0; 
    float magnification = 1.0;
  
	vec4 color = vec4(0.0);
    float center = 1.0E32;
    float angle = atan(uv.y, uv.x)/PI;
    float border = 1.0;
    
    seedling = 0.0;
    
        
    offset = sin(vec2(time+seedling,
                      -time-seedling))*(.5/E);
    
    border *= (1.0-color.a);//*antispeckle;
    
    for(int i = 0; i < max_iterations; i++)
        weights[i] = vec3(vec2(0.0), 1.0);
    
    for(int i = 0; i < max_iterations; i++)
    {
        float iteration = float(i)/float(max_iterations);

        multa = cos(vec2(time*1.1, time*1.2)+iteration*PI*4.0)*.5+1.0;
        offa = cos(vec2(time*1.3, time*1.4)+iteration*PI*4.0)*2.0;
        multb = cos(vec2(time*1.5, time*1.6)+iteration*PI*4.0)*.5+1.0;
        offb = cos(vec2(time*1.7, time*1.8)+iteration*PI*4.0)*2.0;

        seedling = float(i);
        extraTurns = float(i*i+1);

        uv = iterate(uv, .5/iResolution.xy, magnification, multa, offa, multb, offb);
        antispeckle *= stretch;

        float weight = smoothstep(0.0, 1.0, pow(antispeckle, 1.0/float(i+1)));
        
        weights[i] = vec3(uv*2.0-1.0, weight);

        float draw = border*(1.0-color.a);

        float skip = saw(floor(uv.x+uv.y)*PI*123.0);

        vec3 p = vec3(saw(uv*PI), sphereN(saw(uv*PI)));
        
        center = min(center, distTree);
        
        angle = (angle*angleTree);
        
        color += (galaxy((p.xy)*2.0-1.0)+stars(p.xy))*draw*weight;//+stars(p.xy)*draw, 0.0, 1.0);
        border *= draw;//*antispeckle;

    }
    
    gl_FragColor = vec4((color)*GR);
}